<?php
/**
* Useful debugging methods for developers. 
* {@link prp} and its variants were originally developed at Carleton College for the {@link http://apps.carleton.edu/opensource/reason/ Reason project}.
* @package direct-as-a-service
* @subpackage development
*/

/**
* This function is meant primarly to overcome the tedium of writing* "echo '<pre></pre>'" etc. all the time, as well as to make the output look a little nicer.
*
* (Designed to combine the advantages of pray and print_r.)
*
* @author Nathanael Fillmore, 2003-12-23
* @author Modified by Dave Hendler, 2004-09-03
*
* @uses sprp
* @param $v mixed variable/object/thing to print
* @param $k string label for $v (defaults to 'prp')
 */
if(!function_exists('prp')){
	function prp($v, $k = 'prp'){
		echo sprp( $v, $k);
	}
}

/**
* Displays just the values of an entity object.
* Entities have references to models and other gigantic objects that are unreadable in prps, so this will just iterate through the values array for the entity.
* @param array
* @param string
*/
if(!function_exists('prp_entities')){
	function prp_entities($entities, $description = 'prp_entities'){
		if(is_a($entities, 'Entity')) return prp($entities->values, $description);
		if(!is_array($entities)) return prp($entities, $description);
		foreach($entities as $key => $entity){
			if(is_object($entity) && is_a($entity, 'Entity'))
				$entities[$key] = $entity->values;
		}
		prp($entities, $description);
	}
}
 
/**
* Generates the text used by {@link prp} without echoing it.
* @param $v mixed variable/object/thing to print
* @param $k string label for $v (defaults to 'prp')
* @return string
*/ 
if(!function_exists('sprp')){
	function sprp( $v, $k = 'sprp'){
		$str = '';
		$str .= "\n";
		$str .= "<div><pre><strong>[$k]</strong>\n";
		ob_start();
		if ( is_array($v) || is_object($v) )
			echo "\n";
		print_r($v);
		$print_r = ob_get_contents();
		ob_end_clean();
		$str .= htmlspecialchars($print_r);
		$str .= "\n<strong>[/$k]</strong></pre></div>";
		$str .= "\n";
		return $str;
	}
}

/**
* Generates the same text as {@link sprp}, but optimized for logging.
* @param $v mixed variable/object/thing to print
* @param $k string label for $v (defaults to 'prp')
* @return string
*/ 
if(!function_exists('sprp_for_log')){
	function sprp_for_log( $v, $k = 'sprp'){
		$str = '';
		$str .= "\n";
		$str .= "[$k]\n";
		ob_start();
		if ( is_array($v) || is_object($v) )
			echo "\n";
		print_r($v);
		$print_r = ob_get_contents();
		ob_end_clean();
		$str .= $print_r."\n[/$k]";
		$str .= "\n";
		return $str;
	}
}

?>